using System;
using Server.Network;
using System.Collections;
using Server.Spells;
using Server.Mobiles;

namespace Server.Items
{
	public class PacifyTotem : BaseTotem
	{
      [Constructable]
		public PacifyTotem( int charges, Mobile owner ) : base( TotemType.Pacify, charges, owner )
		{
			Name = String.Format( "{0} totem [{1}]", ( Owner.HeadArmor is ShamansMask ) ? "freezing" : "pacify", this.Owner.RawName.ToLower() );
			ItemID = 13904;
		}
		
		public override void DoEffect( int count )
		{
//          this.PublicOverheadMessage( MessageType.Regular, 0x22, false, count.ToString() );
         
			if ( count % 3 == 0 )
			{
				Effects.PlaySound( this.Location, this.Map, 0x207 );
				ZoogiVejce.EffectCircle( this.Location, this.Map, 4, 0x376A );
				
				foreach ( Mobile mobile in this.Map.GetMobilesInRange( this.Location, 5 ) )
				{
					if ( mobile == null || mobile.Deleted || mobile.Blessed || !mobile.Alive || !mobile.InLOS( this ) || mobile is BaseChampion )
						continue;
					
					if ( mobile is BaseCreature && !((BaseCreature)mobile).Controlled && !mobile.IsDeadBondedPet )
					{
						if ( Owner.HeadArmor is ShamansMask )
						   mobile.Freeze( TimeSpan.FromSeconds( 3.0 ) );
						else
                     ((BaseCreature)mobile).Pacify( Owner, DateTime.Now + TimeSpan.FromSeconds( 4.0 ) ); // TODO check
					}
				}
			}
      }

		public PacifyTotem( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}